<?php
/*
Plugin Name: AurumPay OTC - BC Gateway
Plugin URI: http://www.aurumpay.com/
Description: AurumPay OTC(Over-The-Counter) Gateway Plugin for WooCommerce. AurumPay® Philippines is the first Filipino-owned online payment gateway service provider that services the online payment requirements of the Philippine ecommerce market with its very own multiple line-up of online payment solutions.
Version: 2.0
Author: MiW
Author URI: http://www.miwsolutions.com/
*/

add_action('plugins_loaded','class_apotcbc_init',0);
function class_apotcbc_init() {
	if( ! class_exists( 'WC_Payment_Gateway' )) {
		return;
	};


/** GATEWAY CLASS **/
class  WC_apotcbc extends WC_Payment_Gateway {
	public function __construct() {
		global $woocommerce;
		$this->id = 'apotcbc';
		$this->method_title = __(' Aurumpay OTC - BC', 'woocommerce');
		$this->has_fields = false;
		$this->icon = false;

		/** LOAD ADMIN FIELDS AND SETTINGS **/
		$this->init_form_fields();
		$this->init_settings();
		/** OPTIONS **/
		$this->title = $this->get_option('title');
		$this->description = $this->get_option('description');
		$this->gatewayurl = $this->get_option('gatewayurl');
		$this->responseurl = $this->get_option('responseurl');
		$this->apiurl = $this->get_option('apiurl');
		$this->merchantid = $this->get_option('merchantid');
		$this->endpointid = $this->get_option('endpointid');
		$this->login = $this->get_option('login');
		$this->merchant_name = $this->get_option('merchant_name');
        

		add_action('woocommerce_api_wc_apotcbc', array($this, 'check response'));
		add_action('woocommerce_receipt_apotcbc', array($this, 'receipt_page'));
		add_action('woocommerce_update_options_payment_gateways_' .$this->id, array($this, 'process_admin_options' ));
		}

	function check_response(){
		if (isset($_POST['customerReference']) && isset($_POST['responseCode'])) :
			@ob_clean();
			$_POST = stripslashes_deep($_POST);
			if (!empty($_POST['customerReference']) && !empty($_POST['responseCode'])) :
				header('HTTP/1.1 200 OK');
				$this->successful_request($_POST);
			else :
				wp_die("Request Failure");
			endif;
		endif;
		}

	function successful_request( $posted ) {
		global $woocommerce;
		$order_id_key=$posted['customerReference'];
		$order_id_key=explode("-",$order_id_key);
		$order_id=$order_id_key[0];
		$order_key=$order_id_key[1];
		$status=$posted['status'];
		$order = new WC_Order( $order_id );
		   if ( $order->order_key !== $order_key ) :
			echo 'Error: Order Key does not match invoice.';
			exit;
			endif;
		   if ( $order->get_total() != $posted['amount'] ) {
			echo 'Error: Amount not match.';
			$order->update_status( 'on-hold', sprintf( __( 'Validation error: AurumPay amounts do not match (%s).', 'woocommerce' ), $posted['amount'] ) );
				exit;
			}

		  // if TXN is approved
		  if($status == "approved"){
				// Payment completed
				$order->add_order_note( __('payment completed', 'woocommerce') );
				// Mark order complete
				$order->payment_complete();
				  // Empty cart and clear session
				$woocommerce->cart->empty_cart();
				// Redirect to thank you URL
				wp_redirect( $this->get_return_url( $order ) );
				exit;
			} else {	   
			// Change the status to pending / unpaid
			$order->update_status('pending', __('Payment declined', 'woothemes'));
			// Add a note with the IPG details on it
			$order->add_order_note(__('AurumPay payment Failed - TransactionReference: ' . $status . " - ResponseCode: " .$responseCode, 'woocommerce')); // FAILURE NOTE
			// Add error for the customer when we return back to the cart
			$woocommerce->add_error(__('TRANSACTION DECLINED: ', 'woothemes') . $posted['responseText'] . "<br/>Reference: " . $txnreference);
			// Redirect back to the last step in the checkout process
			wp_redirect( $woocommerce->cart->get_checkout_url());
				exit;
			}

		}

	
		public function admin_options() {
			?>
			<h3><?php _e('AurumPay OTC - BC', 'woocommerce'); ?></h3><table class="form-table">
			<?php
				$this->generate_settings_html();
			?>
			</table><!--/.form-table-->
			<?php
			}

/*** INITIALZE ADMIN FORM FIELDS***/
		function init_form_fields(){
			global $woocommerce;
            if (isset ($order_id))
			$order = new WC_Order( $order_id );
			$this->form_fields = array(
				'enabled' => array(
				'title' => __( 'Enable/Disable', 'woocommerce' ),
				'type' => 'checkbox',
				'label' => __( 'Enable AP BC', 'woocommerce' ),
				'default' => 'yes'
				),
				'title' => array(
				'title' => __( 'Title', 'woocommerce' ),
				'type' => 'text',
				'description' => __( 'This is the title the customer can see when checking out', 'woocommerce' ),
				'default' => __( 'AurumPay OTC - BC', 'woocommerce' )
				),
				'description' => array
				(
				'title' => __( 'Description', 'woocommerce' ),
				'type' => 'text',
				'description' => __( 'This is the description the customer can see when checking out', 'woocommerce' ),
				'default' => __("Pay Over-the-counter via AurumPay", 'woocommerce')
				),
				'endpointid' => array
				(
				'title' => __( 'Endpoint Id', 'woocommerce' ),
				'type' => 'text',
				'description' => __( '', 'woocommerce' ),
				'default' => __('' , 'woocommerce')
				),
				'login' => array
				(
				'title' => __( 'Login', 'woocommerce' ),
				'type' => 'text',
				'description' => __( '', 'woocommerce' ),
				'default' => __('BancNetProdtest' , 'woocommerce')
				),
				'merchant_name' => array
				(
				'title' => __( 'Merchant Name', 'woocommerce' ),
				'type' => 'text',
				'description' => __( 'Your Company Name', 'woocommerce' ),
				'default' => __('' , 'woocommerce')
				),
				'merchantid' => array
				(
				'title' => __( 'Merchant Control', 'woocommerce' ),
				'type' => 'text',
				'description' => __( 'This is obtained through the Merchant Administration Console', 'woocommerce' ),
				'default' => ''
							),	
                'responseurl' => array
				(
				'title' => __( 'Response URL', 'woocommerce' ),
				'type' => 'text',
				'description' => __( 'Input title of your response page e.g. payment-success', 'woocommerce' ),
				'default' => ''
							)	
            );
			}

/*** GET INFORMATION ARGUMENTS ***/
		function get_apotcbc_args( $order ){
			global $woocommerce;
			// $redirect_page_id =get_permalink(11);
			$redirect_page_id = home_url()."/".$this->responseurl;
			//$redirect_page_id = "https://www.aurumpay.com/swift/otc.php";
			$order_id = $order->id;
			$data = array();			
			$data['customerReference'] = $order_id.'-'.$order->order_key;
			$data['description'] = "Payment for order id ".$order_id;
			$data['email'] = $order->billing_email;
			$data['INVNUM'] = $order_id;
			$data['amount'] = number_format($order->get_total(), 2, '.', '');	
			
			/**   AURUMPAY FIELDS ***/
			$data['gatewayurl'] = home_url()."/wp-content/plugins/woocommerce_aurumpay_otcbc/process.php"; 
			/* $data['gatewayurl'] ="https://www.aurumpay.com/payment.php"; */
			$data['apiurl'] = $this->apiurl;
			$data['merchant_control'] = $this->merchantid;
			$data['endpointid'] = $this->endpointid;
			$data['client_orderid'] = $order_id;
			$data['redirect_url'] = $redirect_page_id;
			/* $data['login'] = 'BancNetProdtest'; */
			$data['login'] = $this->login;
			$data['merchant_name'] = $this->merchant_name;
			/** $data['redirect_url'] = $this->responseurl; **/
			/** PERSONAL DATA **/
			$data['order_desc'] = "Payment for ".$order_id;
			$data['first_name'] = $order->billing_first_name;
			$data['last_name'] = $order->billing_last_name;
			$data['address1'] = $order->billing_address_1;
			$data['city'] = $order->billing_city;
			
			$data['zip_code'] = $order->billing_postcode;
			$data['country'] = $order->billing_country;
			$data['phone'] = $order->billing_phone;
			$data['currency'] = 'PHP';
						
			/* CONCATENATION */

			$amount_cents = $data['amount'] * 100;
	  		$data['control'] = sha1($data['endpointid'] . $data['client_orderid'] . $amount_cents . $data['email'] . $data['merchant_control']);
	   		$data['ipaddress']=$_SERVER['REMOTE_ADDR'];

			return $data;
		}

/*** PROCESS PAYMENT **/
		function process_payment( $order_id ){
			$order = new WC_Order( $order_id );
			$apotcbc_args = $this->get_apotcbc_args( $order );		   
			return array
			(
				'result'	 => 'success',
				'redirect'	=> add_query_arg('order', $order->id, add_query_arg('key', $order->order_key, get_permalink(woocommerce_get_page_id('pay'))))
			);
		}

		function receipt_page( $order )
		{
		echo '<p style="padding: 10px;border-width: 1px 1px 1px 5px;border-style: solid;border-color: #50B948;">Kindly make your payment within one week (7 days). Thank you</p><p>'.__('Thank you for your order, click on submit to process AurumPay payment.', 'woocommerce').'</p>';
			echo $this->generate_apotcbc_form( $order );
		}

		function generate_apotcbc_form( $order_id )
		{
			global $woocommerce;
			$order = new WC_Order( $order_id );
			$redirect_url = add_query_arg('wc-api',get_class($this),$redirect_url);
			$apotcbc_args = $this->get_apotcbc_args( $order );
			$apotcbc_args_array = array();
			foreach($apotcbc_args as $key =>$value){
				$apotcbc_args_array[] ="<input type='hidden' name='$key' value='$value' />";
			}

			return '<form action="'.esc_url( $apotcbc_args['gatewayurl'] ).'" method="post" id="apotcbc_payment_form" target="_top">'.implode('',$apotcbc_args_array)
			.'<input type="submit" class="button-alt" id="submit_aurumpay_payment_form" value="'.__('Pay via AurumPay&reg;','miw').'"/><a class="button cancel"
			href="'.$order->get_cancel_order_url().'">'.__('Cancel Order &amp; Restore Cart','miw').'</a>
			<script type="text/javascript">
			jQuery(function(){
				jQuery("body").block(
				{
					message: "<img src=\"'.$woocommerce->plugin_url().'/assets/ajax-loader.gif\" alt=\"Redirecting...\"
					style=\"float:left; margin-right: 10px;\" />'.__('Thank you for your order. We are now redirecting you to AurumPay to make payment.','miw').'",
					overlayCSS:{
						background: "#fff",
						opacity: 0.6
						},
					css: {
						padding: 20,
						textAlign: "center",
						color: "#555",
						border: "3px solid #aaa",
						backgroundColor: "#fff",
						cursor: "wait",
						lineHeight:"32px"
						}
					});
				jQuery("#submit_aurumpay_payment_form").click();
				});
				</script>
				</form>';
			/* $return='<form action="'.esc_url( $apotcbc_args['gatewayurl'] ).'" method="post" id="apotcbc_payment_form" target="_top">';
			
			 foreach ($apotcbc_args as $key => $value) {
				if($key!='gatewayurl')
				$return .= '<input type="hidden" name="'.esc_attr( $key ).'" value="'.esc_attr( $value ).'" />';
			 }
			$return .='<input type="submit" id="submit_apotcbc_payment_form" value="Submit"/></form>';
			return $return; */
		}
    
    function get_pages($title = false, $indent = true) {
        $wp_pages = get_pages('sort_column=menu_order');
        $page_list = array();
        if ($title) $page_list[] = $title;
        foreach ($wp_pages as $page) {
            $prefix = '';
            // show indented child pages?
            if ($indent) {
                $has_parent = $page->post_parent;
                while($has_parent) {
                    $prefix .=  ' - ';
                    $next_page = get_page($has_parent);
                    $has_parent = $next_page->post_parent;
                }
            }
            // add to page list array array
            $page_list[$page->ID] = $prefix . $page->post_title;
        }
        return $page_list;
    }
    
	}

function woocommerce_apotcbc_add_gateway( $methods )
	{
		$methods[] = 'WC_apotcbc';
		return $methods;

	}

	add_filter( 'woocommerce_payment_gateways', 'woocommerce_apotcbc_add_gateway' );
}



?>